<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo que contiene la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");

// file_put_contents("log_json.txt", file_get_contents("php://input"));

// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);
// file_put_contents("log_php.txt", print_r($datos, true));

$rows = array();

try {
    $datos[4] = filter_var($datos[4], FILTER_VALIDATE_BOOLEAN);

    // Preparar la llamada a la función en PostgreSQL
    $sql = "SELECT * FROM Buscar_SeriesxDocxUsuario(:param1, :param2, :param3, :param4, :param5)"; // Asume que Buscar_SeriesxDocxUsuario es una función en PostgreSQL
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':param1', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':param2', $datos[1], PDO::PARAM_INT);
    $stmt->bindValue(':param3', $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':param4', $datos[3], PDO::PARAM_INT);
    $stmt->bindValue(':param5', $datos[4], PDO::PARAM_BOOL);
    $stmt->execute();

    // Obtener el resultado de la función
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($rows)) {
        // No se encontraron registros
        $rows = [];
    }
} catch (PDOException $e) {
    error_response("Error al ejecutar la consulta: " . $e->getMessage());
}

// Cerrar la conexión a la base de datos
$conn = null;

// file_put_contents("log_php.txt", print_r($rows, true));

// Imprimir la respuesta en formato JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>